# RadarAnalyzer Bot

A Telegram bot for analyzing tokens across multiple blockchains (BSC, ETH, Solana).

## Features

- Token contract analysis
- Token safety assessment
- Price and liquidity information
- Holder distribution analysis
- Buy/sell tax detection
- Multi-chain support

## Installation

1. Clone the repository
2. Install dependencies:
```bash
npm install
```
3. Configure your `.env` file with API keys and RPC URLs
4. Start the bot:
```bash
npm start
```

## Usage

Once the bot is running, you can interact with it on Telegram:

1. Start a chat with the bot
2. Use `/start` to see introduction
3. Send a token contract address to analyze it
4. Use `/analyze <address>` to explicitly analyze an address

## Supported Networks

- Binance Smart Chain (BSC)
- Ethereum (ETH)
- Solana (SOL)

## Dependencies

- node-telegram-bot-api
- web3
- ethers
- axios
- moment
- @solana/web3.js
- dotenv

## Adding Support for More Networks

To add support for a new blockchain network:

1. Create a new service file in the `services` directory
2. Implement the required functions to fetch token details
3. Update the `analyzer.js` file to include the new service
4. Update the network detector in `networkDetector.js`

## License

MIT
