const axios = require('axios');
require('dotenv').config();

const BSC_API_KEY = process.env.BSC_API_KEY;
const BSCSCAN_API = 'https://api.bscscan.com/api';

/**
 * Get token holder info from BSCScan
 */
async function getBscHolderInfo(address) {
  try {
    const response = await axios.get(BSCSCAN_API, {
      params: {
        module: 'token',
        action: 'tokenholderlist',
        contractaddress: address,
        apikey: BSC_API_KEY
      }
    });
    
    if (response.data.status === '1' && response.data.result.length > 0) {
      const totalSupply = response.data.result.reduce(
        (sum, holder) => sum + parseFloat(holder.TokenHolderQuantity), 0
      );
      
      const holders = response.data.result.slice(0, 5).map(holder => ({
        address: holder.TokenHolderAddress,
        balance: holder.TokenHolderQuantity,
        percentage: (parseFloat(holder.TokenHolderQuantity) / totalSupply) * 100
      }));
      
      return {
        count: response.data.result.length,
        top: holders,
        source: 'BSCScan'
      };
    }
    
    return { count: 'Unknown', top: [], source: 'BSCScan' };
  } catch (error) {
    console.error('Error getting BSCScan holder info:', error);
    return { count: 'Unknown', top: [], source: 'BSCScan' };
  }
}

module.exports = {
  getBscHolderInfo
};
