const { getHoldersViaWebSocket } = require('./dexScreenerSocket');

/**
 * Fetch holder data for a token, ONLY from API - no random estimates
 */
async function getHolderInfo(address, network) {
  try {
    console.log(`Fetching holder data for: ${address} (${network})`);
    
  // Call function to retrieve holder data from the API
  const holderData = await getHoldersViaWebSocket(address, network);
    
    // Validate data: ONLY return data if it truly exists
    if (holderData && holderData.count && holderData.count > 0) {
      console.log(`✅ Holder data found: ${holderData.count}`);
      return {
        count: holderData.count,
        source: "Data API", // Hide source
        url: null // Remove URL
      };
    }
    
    console.log(`❌ No valid holder data found`);
    return { count: 0 };
  } catch (error) {
    console.error(`Error in getHolderInfo:`, error);
    return { count: 0 };
  }
}

module.exports = {
  getHolderInfo
};
