/**
 * Simple logging utility for consistent error messages
 */

function logError(context, error) {
  console.error(`[ERROR] ${context}: ${error.message}`);
  if (error.stack) {
    console.error(`Stack trace: ${error.stack.split('\n')[1]}`);
  }
}

function logInfo(message) {
  console.log(`[INFO] ${message}`);
}

function logWarning(message) {
  console.log(`[WARN] ${message}`);
}

module.exports = {
  logError,
  logInfo,
  logWarning
};
