/**
 * Detects which network a token address belongs to based on address format
 */
function detectNetwork(address) {
  if (!address) return null;
  address = String(address).replace(/\s+/g, '').trim();
  console.log('[detectNetwork] Checking address:', address);
  // Ethereum, BSC (0x format)
  if (/^0x[a-fA-F0-9]{40}$/.test(address)) {
    return 'ETH';
  }
  // Solana (base58, 32-44 chars, very permissive)
  if (/^[1-9A-HJ-NP-Za-km-z]{32,44}$/.test(address)) {
    return 'SOL';
  }
  return null;
}

module.exports = {
  detectNetwork
};
